function createMenu() {
    const headerLeft = document.querySelector('.header-align-container.left');
    const headerRight = document.querySelector('.header-align-container.right');

    let menuItems = {
        'Meine Suchen': '../my-searches/my-searches.html',
        'Neue Suche': '../search/search.html',
        'Login': '../login/login.html',
        'Logout': () => {
            api.logout();
            window.location = '../login/login.html'
        }
    }

    let hrefParts = window.location.href.split('/');
    let filename = hrefParts[hrefParts.length-1];

    if(filename === 'login.html') {
        delete menuItems['Meine Suchen'];
        delete menuItems['Neue Suche'];
        delete menuItems['Logout'];
    }
    else {
        delete menuItems['Login'];
    }

    for(let key in menuItems) {
        let item = menuItems[key];
        if(typeof(item) == 'string') {
            let menuEl = document.createElement('a');
            menuEl.href = item;
            menuEl.textContent = key;
            menuEl.classList.add('header-nav-item');
            let itemParts = item.split('/');
            let itemFilename = itemParts[itemParts.length-1];
            if(itemFilename === filename) {
                menuEl.classList.add('highlighted');
            }
            headerRight.appendChild(menuEl);
        }
        else if(typeof(item) == 'function') {
            let menuEl = document.createElement('button');
            menuEl.textContent = key;
            menuEl.classList.add('header-nav-item');
            menuEl.addEventListener('click',(e) => {
                e.preventDefault();
                item();
            })
            headerRight.appendChild(menuEl);
        }
    }
}
createMenu();